USE [V5_Registry] 

GO
	--Insert Survey Information
	INSERT INTO [dbo].[STD_SURVEY_TYPE]
           ([CODE],[NAME],[DESCRIPTION_TEXT],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES
           ('QUEST', 'Quebec User Evaluation of Satisfaction with Assistive Technology', 'Quebec User Evaluation of Satisfaction with Assistive Technology', 'Initial', 'Initial', GETDATE(), GETDATE());

	declare @type     int;
	SELECT @type=  (SELECT ID [STD_SURVEY_TYPE_ID]
	FROM STD_SURVEY_TYPE
	WHERE CODE = 'QUEST');

	INSERT INTO [dbo].[STD_QUESTION]
	([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
		 VALUES
			   (@type, 'TechDev', 'Technology device:', 1, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL);

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, 'D', 'Date of assessment:', 2, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '1', 'the dimensions (size, height, length, width) of your assistive device?', 3, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '1Comment', 'Comments:', 4, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '2', 'the weight of your assistive device?', 5, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '2Comment', 'Comments:', 6, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '3', 'the ease in adjusting (fixing, fastening) the parts of your assistive device?', 7, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '3Comment', 'Comments:', 8, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '4', 'how safe and secure your assistive device is?', 9, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '4Comment', 'Comments:', 10, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '5', 'the durability (endurance, resistance to wear) of your assistive device?', 11, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '5Comment', 'Comments:', 12, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '6', 'how easy it is to user your assistive device?', 13, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '6Comment', 'Comments:', 14, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '7', 'how comfortable your assistive device is?', 15, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '7Comment', 'Comments:', 16, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '8', 'how effective your assistive device is (the degree to which your device meets your needs)?', 17, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '8Comment', 'Comments:', 18, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '9', 'the service delivery program (procedures, length of time) in which your obtained your assistive device?', 19, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '9Comment', 'Comments:', 20, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '10', 'the repairs and servicing (maintenance) provided for your assistive device?', 21, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '10Comment', 'Comments:', 22, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '11', 'the quality of the professional services (information, attention) your received for using your assistive device?', 23, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '11Comment', 'Comments:', 24, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '12', 'the follow-up services (continuing support services) received for your assistive device?', 25, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '12Comment', 'Comments:', 26, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '13', 'Below is the list of the same 12 satisfaction items. PLEASE SELECT THE THREE ITEMS that you consider to be the most important to you.  Please put an X in the 3 boxes of your choice.', 27, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '14', 'Number of non-valid responses', 28, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)           
 
	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '15', 'Device subscale score', 29, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)   
		   
	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '16', 'Services subscale score', 30, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL) 
		   
	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '17', 'Total QUEST score', 31, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)      


	declare @question     int, 
			@choice       int;       

	--Tech Dev Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 1)	
	--Tech Dev Choices
	SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [dbo].[STD_QUESTION_CHOICE]) + 1)
	--If choice is null, meaning the choice table is empty, set it to 1
	IF @choice IS NULL SET @choice = 1
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Technology Device Text' ,'Technology Device Text',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	
	--Date Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 2)
	--Date Choice
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Date', 'Date', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 1 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 3)
	--Question 1 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 1 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 4)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 1 Comments' ,'Question 1 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 2 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 5)
	--Question 2 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 2 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 6)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 2 Comments' ,'Question 2 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())


	--Question 3 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 7)
	--Question 3 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 3 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 8)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 3 Comments' ,'Question 3 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 4 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 9)
	--Question 4 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 4 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 10)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 4 Comments' ,'Question 4 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 5 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 11)
	--Question 5 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 5 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 12)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 5 Comments' ,'Question 5 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 6 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 13)
	--Question 6 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 6 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 14)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 6 Comments' ,'Question 6 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 7 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 15)
	--Question 7 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 7 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 16)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 7 Comments' ,'Question 7 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 8 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 17)
	--Question 8 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 8 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 18)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 8 Comments' ,'Question 8 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 9 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 19)
	--Question 9 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 9 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 20)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 9 Comments' ,'Question 9 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 10 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 21)
	--Question 10 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 10 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 22)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 10 Comments' ,'Question 10 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 11 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 23)
	--Question 11 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 11 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 24)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 11 Comments' ,'Question 11 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 12 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 25)
	--Question 12 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Not satisfied at all', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Not very satisfied', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'More or less satisfied', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Quite satisfied', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Very satisfied', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 12 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 26)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 12 Comments' ,'Question 12 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 26 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 27)
	--Question 26 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', '1. Dimensions', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', '2. Weight', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', '3. Adjustments', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', '4. Safety', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', '5. Durability', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', '6. Easy to use', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', '7. Comfort', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '8', '8. Effectiveness', 8, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
		   SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '9', '9. Service delivery', 9, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
		   SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '10 ', '10. Repairs/servicing', 10, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
		   SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '11', '11. Professional Service', 11, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
		   SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '12', '12. Follow-up services', 12, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 27 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 28)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 27 Text' ,'Question 27 Text',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 28 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 29)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 28 Text' ,'Question 28 Text',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 29 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 30)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 29 Text' ,'Question 29 Text',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 30 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'QUEST' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 31)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 30 Text' ,'Question 30 Text',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

GO